<?php
// Include the database connection file
include('includes/db.php');

// Start session to track OTP state, if needed
session_start();

// Check if the form is submitted
if (isset($_POST['submit'])) {
    // Retrieve the email entered by the user
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

    // Check if the email is valid
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Invalid email address");
    }

    // Generate a 6-digit random OTP
    $otp = rand(100000, 999999);

    // Set the OTP expiry time (e.g., 15 minutes from now)
    $expiry = date('Y-m-d H:i:s', strtotime('+15 minutes'));

    // Get database connection
    $pdo = getDbConnection();

    // Check if an OTP already exists for the email
    $stmt = $pdo->prepare("SELECT * FROM otps WHERE email = :email AND expiry > NOW()");
    $stmt->execute(['email' => $email]);
    $existingOtp = $stmt->fetch();

    if ($existingOtp) {
        echo "An OTP has already been sent to this email. Please check your inbox.";
        exit();
    }

    // Insert OTP into the database
    $stmt = $pdo->prepare("INSERT INTO otps (email, otp, expiry) VALUES (:email, :otp, :expiry)");
    $stmt->execute(['email' => $email, 'otp' => $otp, 'expiry' => $expiry]);

    // Send the OTP via email
    $subject = "Your OTP Code";
    $message = "Your OTP code is: $otp\nIt will expire in 15 minutes.";
    $headers = "From: no-reply@yourdomain.com";

    // You can use PHP's mail() function, or replace it with a mail service like SendGrid or Mailgun
    if (mail($email, $subject, $message, $headers)) {
        echo "OTP sent successfully to your email!";
        // Optionally, you could redirect to the OTP verification page
        // header("Location: verify.php");
        // exit();
    } else {
        echo "Failed to send OTP. Please try again.";
    }
} else {
    // Display the form if it's not submitted
    ?>
    <form action="send_otp.php" method="POST">
        <label for="email">Enter your email:</label>
        <input type="email" name="email" required />
        <button type="submit" name="submit">Send OTP</button>
    </form>
    <?php
}
?>
