<?php
// Include the database connection file
include('includes/db.php');

// Start session to track OTP state, if needed
session_start();

// Check if the OTP form is submitted
if (isset($_POST['submit'])) {
    // Retrieve the OTP entered by the user and email (you could also use session to store email)
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $otp = filter_var($_POST['otp'], FILTER_SANITIZE_NUMBER_INT);

    // Check if the email and OTP are valid
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Invalid email address");
    }
    if (empty($otp) || strlen($otp) !== 6) {
        die("Invalid OTP. Please enter a 6-digit OTP.");
    }

    // Get the PDO connection
    $pdo = getDbConnection();

    // Fetch the OTP details from the database based on email and OTP
    $stmt = $pdo->prepare("SELECT * FROM otps WHERE email = :email AND otp = :otp AND expiry > NOW()");
    $stmt->execute(['email' => $email, 'otp' => $otp]);
    $otpRecord = $stmt->fetch();

    // Check if the OTP is valid and not expired
    if ($otpRecord) {
        // OTP is valid
        // Optional: Mark the OTP as used or delete it
        $deleteStmt = $pdo->prepare("DELETE FROM otps WHERE email = :email AND otp = :otp");
        $deleteStmt->execute(['email' => $email, 'otp' => $otp]);

        // Proceed with the next step (e.g., user registration or login)
        // You could create a session for the user, or redirect them to a registration page
        echo "OTP successfully verified! You can now proceed with your registration or login.";

        // Example: Redirect to registration page
        // header("Location: register_user.php"); 
        // exit();
    } else {
        // OTP is invalid or expired
        echo "Invalid OTP or OTP has expired. Please try again.";
    }
} else {
    // Display the form if it's not submitted
    ?>
    <form action="verify_otp.php" method="POST">
        <label for="email">Enter your email:</label>
        <input type="email" name="email" required />
        
        <label for="otp">Enter OTP:</label>
        <input type="text" name="otp" required />
        
        <button type="submit" name="submit">Verify OTP</button>
    </form>
    <?php
}
?>
